﻿using System;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    public class ValidateBusinessRuleStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Validates the business rules before sending the Ec Request to the EC so that no validation errors are expected from AFS side
        /// </summary>
        /// <param name="state"></param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            var errors = ValidateBusinessRules(state.CancelAppointmentRequest.VIMTTmpCancelAppointmentRequestDataInfo);
            if (!string.IsNullOrEmpty(errors))
            {
                throw new Exception(errors);
            }
        }

        private string ValidateBusinessRules(VIMTTmpCancelAppointmentRequestData ecRequest)
        {
            var validator = new BusinessRuleValidator();
            return validator.ValidateCancelRequest(ecRequest);
        }
    }
}